/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.representation;

import com.github.krukow.clj_lang.IPersistentMap;
import com.github.krukow.clj_lang.PersistentHashMap;
import com.github.krukow.clj_lang.PersistentHashSet;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DependencyGraph {
    IPersistentMap<String, Node> graph;

    public DependencyGraph() {
        this((IPersistentMap<String, Node>)PersistentHashMap.emptyMap());
    }

    private DependencyGraph(IPersistentMap<String, Node> graph) {
        this.graph = graph;
    }

    public DependencyGraph addVertex(String element) {
        if (!this.graph.containsKey((Object)element)) {
            return new DependencyGraph((IPersistentMap<String, Node>)this.graph.assoc((Object)element, (Object)new Node(element)));
        }
        return this;
    }

    public boolean containsVertex(String element) {
        return this.graph.containsKey((Object)element);
    }

    public Set<String> getVertices() {
        HashSet<String> vertices = new HashSet<String>();
        for (Map.Entry entry : this.graph) {
            vertices.add((String)entry.getKey());
        }
        return vertices;
    }

    public Set<Edge> getEdges() {
        HashSet<Edge> set = new HashSet<Edge>();
        for (Map.Entry entry : this.graph) {
            set.addAll(((Node)entry.getValue()).getOutEdges());
        }
        return set;
    }

    public Set<Edge> getOutEdges(String name) {
        Node node = (Node)this.graph.valAt((Object)name);
        return node.getOutEdges();
    }

    public Set<Edge> getIncomingEdges(String name) {
        HashSet<Edge> set = new HashSet<Edge>();
        for (Edge edge : this.getEdges()) {
            if (!edge.getTo().getElementName().equals(name)) continue;
            set.add(edge);
        }
        return set;
    }

    public DependencyGraph addEdge(String from, String to, ERefType relationship) {
        IPersistentMap newgraph = this.graph;
        if (!newgraph.containsKey((Object)from)) {
            newgraph = newgraph.assoc((Object)from, (Object)new Node(from));
        }
        if (!newgraph.containsKey((Object)to)) {
            newgraph = newgraph.assoc((Object)to, (Object)new Node(to));
        }
        Node f = (Node)newgraph.valAt((Object)from);
        Node t = (Node)newgraph.valAt((Object)to);
        Edge e = new Edge(f, t, relationship);
        return new DependencyGraph((IPersistentMap<String, Node>)newgraph.assoc((Object)from, (Object)f.addEdge(e)));
    }

    public DependencyGraph removeEdge(String from, String to, ERefType relationship) {
        Node f = (Node)this.graph.valAt((Object)from);
        Node t = (Node)this.graph.valAt((Object)to);
        if (f == null || t == null) {
            throw new IllegalArgumentException("Nodes must be specified in order to be deleted.");
        }
        return new DependencyGraph((IPersistentMap<String, Node>)this.graph.assoc((Object)from, (Object)f.removeEdge(new Edge(f, t, relationship))));
    }

    public List<ERefType> getRelationships(String from, String to) {
        if (!this.graph.containsKey((Object)from)) {
            throw new IllegalArgumentException("Element " + from + " is not in graph.");
        }
        if (!this.graph.containsKey((Object)to)) {
            throw new IllegalArgumentException("Element " + to + " is not in graph.");
        }
        Node f = (Node)this.graph.valAt((Object)from);
        Node t = (Node)this.graph.valAt((Object)to);
        Set<Edge> edgeSet = f.getOutEdges();
        ArrayList<ERefType> relationships = new ArrayList<ERefType>();
        for (Edge edge : edgeSet) {
            if (!edge.getFrom().equals(f) || !edge.getTo().equals(t)) continue;
            relationships.add(edge.getRelationship());
        }
        return relationships;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.graph) {
            ArrayList<String> s = new ArrayList<String>();
            Set<Edge> outEdges = ((Node)entry.getValue()).getOutEdges();
            sb.append((String)entry.getKey());
            sb.append(" : ");
            for (Edge edge : outEdges) {
                s.add(edge.getRelationship().toString() + " -> " + edge.getTo().getElementName());
            }
            sb.append(((Object)s).toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public class Edge {
        Node from;
        Node to;
        ERefType relationship;

        public Edge(Node from, Node to, ERefType relationship) {
            this.from = from;
            this.to = to;
            this.relationship = relationship;
        }

        public Node getFrom() {
            return this.from;
        }

        public Node getTo() {
            return this.to;
        }

        public ERefType getRelationship() {
            return this.relationship;
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that instanceof Edge) {
                return this.getFrom().equals(((Edge)that).getFrom()) && this.getTo().equals(((Edge)that).getTo()) && this.getRelationship().equals((Object)((Edge)that).getRelationship());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.from, this.to, this.relationship});
        }
    }

    public class Node {
        final String elementName;
        final PersistentHashSet<Edge> outEdges;

        public Node(String elementName) {
            this(elementName, (PersistentHashSet<Edge>)PersistentHashSet.emptySet());
        }

        private Node(String elementName, PersistentHashSet<Edge> edges) {
            this.elementName = elementName;
            this.outEdges = edges;
        }

        public String getElementName() {
            return this.elementName;
        }

        public Set<Edge> getOutEdges() {
            return this.outEdges;
        }

        public Node addEdge(Edge edge) {
            return new Node(this.elementName, (PersistentHashSet<Edge>)this.outEdges.cons((Object)edge));
        }

        public Node removeEdge(Edge edge) {
            return new Node(this.elementName, (PersistentHashSet<Edge>)this.outEdges.disjoin((Object)edge));
        }

        public boolean equals(Object that) {
            if (this == that) {
                return true;
            }
            if (that instanceof Node) {
                return this.getElementName().equals(((Node)that).getElementName());
            }
            return false;
        }

        public int hashCode() {
            return this.getElementName().hashCode();
        }
    }

    public static enum ERefType {
        SEES,
        USES,
        REFINES,
        INCLUDES,
        IMPORTS,
        EXTENDS;

    }
}

