/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb.translate;

import de.be4.classicalb.core.parser.node.AAbstractConstantsContextClause;
import de.be4.classicalb.core.parser.node.AAxiomsContextClause;
import de.be4.classicalb.core.parser.node.AConstantsContextClause;
import de.be4.classicalb.core.parser.node.ADeferredSetSet;
import de.be4.classicalb.core.parser.node.AEventBContextParseUnit;
import de.be4.classicalb.core.parser.node.AExtendsContextClause;
import de.be4.classicalb.core.parser.node.ASetsContextClause;
import de.be4.classicalb.core.parser.node.ATheoremsContextClause;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PContextClause;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.PPredicate;
import de.be4.classicalb.core.parser.node.TIdentifierLiteral;
import de.prob.animator.domainobjects.EventB;
import de.prob.model.eventb.Context;
import de.prob.model.eventb.EventBAxiom;
import de.prob.model.eventb.EventBConstant;
import de.prob.model.representation.Set;
import de.prob.util.Tuple2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContextTranslator {
    private final Context context;
    private final Map<Node, Tuple2<String, String>> nodeInfos = new HashMap<Node, Tuple2<String, String>>();

    public ContextTranslator(Context context) {
        this.context = context;
    }

    public Map<Node, Tuple2<String, String>> getNodeInfos() {
        return this.nodeInfos;
    }

    public Node translateContext() {
        AEventBContextParseUnit ast = new AEventBContextParseUnit();
        ast.setName(new TIdentifierLiteral(this.context.getName()));
        ArrayList<Object> clauses = new ArrayList<Object>();
        clauses.add(this.processExtends());
        clauses.addAll(this.processConstants());
        clauses.addAll(this.processAxiomsAndTheorems());
        clauses.add(this.processSets());
        ast.setContextClauses(clauses);
        return ast;
    }

    private AExtendsContextClause processExtends() {
        ArrayList<TIdentifierLiteral> extended = new ArrayList<TIdentifierLiteral>();
        for (Context c : this.context.getExtends()) {
            extended.add(new TIdentifierLiteral(c.getName()));
        }
        return new AExtendsContextClause(extended);
    }

    private List<PContextClause> processConstants() {
        ArrayList<PContextClause> constants = new ArrayList<PContextClause>();
        ArrayList<PExpression> concrete = new ArrayList<PExpression>();
        ArrayList<PExpression> abstractC = new ArrayList<PExpression>();
        for (EventBConstant eventBConstant : this.context.getConstants()) {
            if (eventBConstant.isAbstract()) {
                abstractC.add((PExpression)((EventB)eventBConstant.getExpression()).getAst());
                continue;
            }
            concrete.add((PExpression)((EventB)eventBConstant.getExpression()).getAst());
        }
        constants.add((PContextClause)new AConstantsContextClause(concrete));
        constants.add((PContextClause)new AAbstractConstantsContextClause(abstractC));
        return constants;
    }

    private List<PContextClause> processAxiomsAndTheorems() {
        ArrayList<PContextClause> axiomsAndThms = new ArrayList<PContextClause>();
        ArrayList<PPredicate> axioms = new ArrayList<PPredicate>();
        ArrayList<PPredicate> thms = new ArrayList<PPredicate>();
        for (EventBAxiom axiom : this.context.getAxioms()) {
            PPredicate ppred = (PPredicate)((EventB)axiom.getPredicate()).getAst();
            this.nodeInfos.put((Node)ppred, new Tuple2<String, String>(this.context.getName(), axiom.getName()));
            if (axiom.isTheorem()) {
                thms.add(ppred);
                continue;
            }
            axioms.add(ppred);
        }
        axiomsAndThms.add((PContextClause)new AAxiomsContextClause(axioms));
        axiomsAndThms.add((PContextClause)new ATheoremsContextClause(thms));
        return axiomsAndThms;
    }

    private ASetsContextClause processSets() {
        ArrayList<ADeferredSetSet> sets = new ArrayList<ADeferredSetSet>();
        for (Set bSet : this.context.getSets()) {
            ArrayList<TIdentifierLiteral> names = new ArrayList<TIdentifierLiteral>();
            names.add(new TIdentifierLiteral(bSet.getName()));
            sets.add(new ADeferredSetSet(names));
        }
        return new ASetsContextClause(sets);
    }
}

