/*
 * Decompiled with CFR 0.152.
 */
package de.prob.model.eventb;

import de.prob.model.representation.AbstractElement;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.util.Tuple2;
import java.util.List;

public class ProofObligation
extends AbstractElement {
    private final String name;
    private final boolean discharged;
    private final String description;
    private final String sourceName;
    private final List<Tuple2<String, String>> elements;

    public ProofObligation(String sourceName, String name, boolean discharged, String description, List<Tuple2<String, String>> elements) {
        this.sourceName = sourceName;
        this.name = name;
        this.discharged = discharged;
        this.description = description;
        this.elements = elements;
    }

    public String getName() {
        return this.name;
    }

    public void toProlog(IPrologTermOutput pto) {
        pto.openTerm("po");
        pto.printAtom(this.sourceName);
        pto.printAtom(this.description);
        pto.openList();
        for (Tuple2<String, String> element : this.elements) {
            pto.openTerm(element.getFirst());
            pto.printAtom(element.getSecond());
            pto.closeTerm();
        }
        pto.closeList();
        pto.printAtom(String.valueOf(this.discharged));
        pto.closeTerm();
    }
}

