/*
 * Decompiled with CFR 0.152.
 */
package de.prob.cosimulation;

import com.sun.jna.Function;
import com.sun.jna.NativeLibrary;
import com.sun.jna.Pointer;
import de.prob.cosimulation.IFMUListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.ptolemy.fmi.FMICallbackFunctions;
import org.ptolemy.fmi.FMILibrary;
import org.ptolemy.fmi.FMIModelDescription;
import org.ptolemy.fmi.FMIScalarVariable;
import org.ptolemy.fmi.FMUFile;
import org.ptolemy.fmi.FMULibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMU {
    private static final Logger logger = LoggerFactory.getLogger(FMU.class);
    private static final double TIMEOUT = 1000.0;
    String _modelIdentifier;
    NativeLibrary _nativeLibrary;
    private Pointer component;
    private final FMIModelDescription modelDescription;
    private final Map<String, FMIScalarVariable> variables = new HashMap<String, FMIScalarVariable>();
    private final Set<IFMUListener> listeners = new HashSet<IFMUListener>();

    public void registerListener(IFMUListener listener) {
        this.listeners.add(listener);
    }

    public void unregisterListener(IFMUListener listener) {
        this.listeners.remove(listener);
    }

    public FMU(String fmuFileName) throws IOException {
        this.modelDescription = FMUFile.parseFMUFile((String)fmuFileName);
        String sharedLibrary = FMUFile.fmuSharedLibrary((FMIModelDescription)this.modelDescription);
        for (FMIScalarVariable fmiScalarVariable : this.modelDescription.modelVariables) {
            this.variables.put(fmiScalarVariable.name, fmiScalarVariable);
        }
        this._nativeLibrary = NativeLibrary.getInstance((String)sharedLibrary);
        this._modelIdentifier = this.modelDescription.modelIdentifier;
        String fmuLocation = new File(fmuFileName).toURI().toURL().toString();
        String mimeType = "application/x-fmu-sharedlibrary";
        double timeout = 1000.0;
        byte visible = 0;
        byte interactive = 0;
        FMICallbackFunctions.ByValue callbacks = new FMICallbackFunctions.ByValue((FMILibrary.FMICallbackLogger)new FMULibrary.FMULogger(), (FMILibrary.FMICallbackAllocateMemory)new FMULibrary.FMUAllocateMemory(), (FMILibrary.FMICallbackFreeMemory)new FMULibrary.FMUFreeMemory(), (FMILibrary.FMIStepFinished)new FMULibrary.FMUStepFinished());
        byte loggingOn = 0;
        this.component = this.instantiateFMU(fmuLocation, mimeType, timeout, visible, interactive, callbacks, loggingOn);
        if (this.component.equals((Object)Pointer.NULL)) {
            throw new RuntimeException("Could not instantiate model.");
        }
    }

    public String getFmiVersion() {
        assert (this._nativeLibrary != null);
        Function function = this.getFunction("_fmiGetVersion");
        return (String)function.invoke(String.class, new Object[0]);
    }

    public void initialize(double startTime, double endTime) {
        this.invoke("_fmiInitializeSlave", new Object[]{this.component, startTime, (byte)1, endTime}, "Could not initialize slave: ");
    }

    public boolean getBoolean(String name) {
        FMIScalarVariable fmiScalarVariable = this.variables.get(name);
        return fmiScalarVariable.getBoolean(this.component);
    }

    public double getDouble(String name) {
        FMIScalarVariable fmiScalarVariable = this.variables.get(name);
        return fmiScalarVariable.getDouble(this.component);
    }

    public int getInt(String name) {
        FMIScalarVariable fmiScalarVariable = this.variables.get(name);
        return fmiScalarVariable.getInt(this.component);
    }

    public String getString(String name) {
        FMIScalarVariable fmiScalarVariable = this.variables.get(name);
        return fmiScalarVariable.getString(this.component);
    }

    public void set(String name, boolean b) {
        FMIScalarVariable fmiScalarVariable = this.variables.get(name);
        fmiScalarVariable.setBoolean(this.component, b);
    }

    public void set(String name, int i) {
        FMIScalarVariable fmiScalarVariable = this.variables.get(name);
        fmiScalarVariable.setInt(this.component, i);
    }

    public void set(String name, double d) {
        FMIScalarVariable fmiScalarVariable = this.variables.get(name);
        fmiScalarVariable.setDouble(this.component, d);
    }

    public void set(String name, String s) {
        FMIScalarVariable fmiScalarVariable = this.variables.get(name);
        fmiScalarVariable.setString(this.component, s);
    }

    public double doStep(double time, double delta_t) {
        Function doStep = this.getFunction("_fmiDoStep");
        this.invoke(doStep, new Object[]{this.component, time, delta_t, (byte)1}, "Could not simulate, time was " + time + ": ");
        for (IFMUListener l : this.listeners) {
            l.trigger(this.variables);
        }
        return time + delta_t;
    }

    public void terminate() {
        this.invoke("_fmiTerminateSlave", new Object[]{this.component}, "Could not terminate slave: ");
        this.invoke("_fmiFreeSlaveInstance", new Object[]{this.component}, "Could not dispose resources of slave: ");
        this.component = null;
    }

    protected void finalize() throws Throwable {
        this.terminate();
        super.finalize();
    }

    public void reset() {
        this.invoke("_fmiResetSlave", new Object[]{this.component}, "Could not reset slave: ");
    }

    public FMIModelDescription getModelDescription() {
        return this.modelDescription;
    }

    private Pointer instantiateFMU(String fmuLocation, String mimeType, double timeout, byte visible, byte interactive, FMICallbackFunctions.ByValue callbacks, byte loggingOn) {
        Function instantiateSlave = this.getFunction("_fmiInstantiateSlave");
        Pointer fmiComponent = (Pointer)instantiateSlave.invoke(Pointer.class, new Object[]{this._modelIdentifier, this.modelDescription.guid, fmuLocation, mimeType, timeout, visible, interactive, callbacks, loggingOn});
        return fmiComponent;
    }

    public Function getFunction(String name) {
        logger.debug("Getting the {} function.", (Object)name);
        return this._nativeLibrary.getFunction(this._modelIdentifier + name);
    }

    public void invoke(String name, Object[] arguments, String message) {
        Function function = this.getFunction(name);
        this.invoke(function, arguments, message);
    }

    public void invoke(Function function, Object[] arguments, String message) {
        logger.debug("Invoking  {}", (Object)function.getName());
        int fmiFlag = (Integer)function.invoke(Integer.class, arguments);
        if (fmiFlag > 1) {
            throw new RuntimeException(message + fmiFlag);
        }
    }
}

