/*
 * Decompiled with CFR 0.152.
 */
package de.prob.cli;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import de.prob.cli.ModuleCli;
import de.prob.cli.OsSpecificInfo;
import java.io.File;

@Singleton
class OsInfoProvider
implements Provider<OsSpecificInfo> {
    private final OsSpecificInfo osInfo;

    @Inject
    public OsInfoProvider(@ModuleCli.OsName String osString, @ModuleCli.OsArch String osArch) {
        this.osInfo = this.whichOs(osString, osArch);
    }

    public OsSpecificInfo get() {
        return this.osInfo;
    }

    private OsSpecificInfo whichOs(String osString, String osArch) {
        String os = osString.toLowerCase();
        if (os.indexOf("win") >= 0) {
            if (osArch.equals("amd64")) {
                new OsSpecificInfo("probcli.exe", null, "lib" + File.separator + "send_user_interrupt.exe", "Windows", osString, "win64");
            }
            return new OsSpecificInfo("probcli.exe", null, "lib" + File.separator + "send_user_interrupt.exe", "Windows", osString, "win32");
        }
        if (os.indexOf("mac") >= 0) {
            return new OsSpecificInfo("probcli.sh", "sh", "send_user_interrupt", "MacOs", osString, "leopard64");
        }
        if (os.indexOf("linux") >= 0) {
            if (osArch.equals("i386")) {
                return new OsSpecificInfo("probcli.sh", "sh", "send_user_interrupt", "Linux", osString, "linux32");
            }
            if (osArch.equals("amd64")) {
                return new OsSpecificInfo("probcli.sh", "sh", "send_user_interrupt", "Linux", osString, "linux64");
            }
        }
        throw new UnsupportedOperationException("OS not supported");
    }
}

