/*
 * Decompiled with CFR 0.152.
 */
package de.prob.cli;

import de.prob.cli.AbstractCliPattern;
import java.util.regex.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InterruptRefPattern
extends AbstractCliPattern<Long> {
    private Long reference;
    private final Logger logger = LoggerFactory.getLogger(InterruptRefPattern.class);

    public InterruptRefPattern() {
        super("user interrupt reference id: *(\\d+) *$");
    }

    @Override
    protected void setValue(Matcher matcher) {
        this.reference = Long.parseLong(matcher.group(1));
        this.logger.info("Server can receive user interrupts via reference " + this.reference);
    }

    @Override
    public Long getValue() {
        return this.reference;
    }

    @Override
    public void notifyNotFound() {
        this.logger.error("Cannot determine process/thread ID of the Prolog core");
    }

    @Override
    public boolean notFoundIsFatal() {
        return true;
    }
}

