/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.domainobjects;

import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.node.Node;
import de.be4.classicalb.core.parser.node.PExpression;
import de.be4.classicalb.core.parser.node.Switch;
import de.prob.animator.command.EvaluateFormulaCommand;
import de.prob.animator.command.EvaluationCommand;
import de.prob.animator.domainobjects.AbstractEvalElement;
import de.prob.animator.domainobjects.EvalElementType;
import de.prob.animator.domainobjects.EvaluationException;
import de.prob.animator.domainobjects.FormulaExpand;
import de.prob.animator.domainobjects.IBEvalElement;
import de.prob.formula.TranslationVisitor;
import de.prob.model.representation.FormulaUUID;
import de.prob.model.representation.IFormulaUUID;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.statespace.State;
import de.prob.translator.TranslatingVisitor;
import de.prob.translator.types.BObject;
import de.prob.unicode.UnicodeTranslator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.eventb.core.ast.Assignment;
import org.eventb.core.ast.Expression;
import org.eventb.core.ast.FormulaFactory;
import org.eventb.core.ast.IParseResult;
import org.eventb.core.ast.ISimpleVisitor;
import org.eventb.core.ast.Predicate;
import org.eventb.core.ast.extension.IFormulaExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventB
extends AbstractEvalElement
implements IBEvalElement {
    Logger logger = LoggerFactory.getLogger(EventB.class);
    private final FormulaUUID uuid = new FormulaUUID();
    private String kind;
    private Node ast = null;
    private final Set<IFormulaExtension> types;

    public EventB(String code) {
        this(code, Collections.emptySet());
    }

    public EventB(String code, Set<IFormulaExtension> types) {
        this(code, types, FormulaExpand.truncate);
    }

    public EventB(String code, Set<IFormulaExtension> types, FormulaExpand expansion) {
        this.code = UnicodeTranslator.toAscii((String)code);
        this.types = types;
        this.expansion = expansion;
    }

    public void ensureParsed() {
        String unicode = UnicodeTranslator.toUnicode((String)this.code);
        this.kind = EvalElementType.PREDICATE.toString();
        IParseResult parseResult = FormulaFactory.getInstance(this.types).parsePredicate(unicode, null);
        ArrayList<String> errors = new ArrayList<String>();
        if (!parseResult.hasProblem()) {
            this.ast = this.preparePredicateAst(parseResult);
        } else {
            errors.add("Parsing predicate failed because: " + parseResult.toString());
            this.kind = EvalElementType.EXPRESSION.toString();
            parseResult = FormulaFactory.getInstance(this.types).parseExpression(unicode, null);
            if (!parseResult.hasProblem()) {
                this.ast = this.prepareExpressionAst(parseResult);
            } else {
                errors.add("Parsing expression failed because: " + parseResult.toString());
                this.kind = EvalElementType.ASSIGNMENT.toString();
                parseResult = FormulaFactory.getInstance(this.types).parseAssignment(unicode, null);
                if (!parseResult.hasProblem()) {
                    this.ast = this.prepareAssignmentAst(parseResult);
                } else {
                    errors.add("Parsing assignment failed because: " + parseResult.toString());
                }
            }
        }
        if (parseResult.hasProblem()) {
            for (String string : errors) {
                this.logger.error(string);
            }
            this.logger.error("Parsing of code failed. Ascii is: " + this.code);
            this.logger.error("Parsing of code failed. Unicode is: " + unicode);
            throw new EvaluationException("Was not able to parse code: " + this.code + " See log for details.");
        }
    }

    private Node prepareAssignmentAst(IParseResult parseResult) {
        Assignment assign = parseResult.getParsedAssignment();
        TranslationVisitor visitor = new TranslationVisitor();
        try {
            assign.accept((ISimpleVisitor)visitor);
        }
        catch (Exception e) {
            this.logger.error("Creation of ast failed for assignment " + this.code, (Throwable)e);
            throw new EvaluationException("Could not create AST for assignment " + assign.toString());
        }
        return visitor.getSubstitution();
    }

    private Node prepareExpressionAst(IParseResult parseResult) {
        Expression expr = parseResult.getParsedExpression();
        TranslationVisitor visitor = new TranslationVisitor();
        try {
            expr.accept((ISimpleVisitor)visitor);
        }
        catch (Exception e) {
            this.logger.error("Creation of ast failed for expression " + this.code, (Throwable)e);
            throw new EvaluationException("Could not create AST for expression " + expr.toString());
        }
        PExpression expression = visitor.getExpression();
        return expression;
    }

    private Node preparePredicateAst(IParseResult parseResult) {
        Predicate parsedPredicate = parseResult.getParsedPredicate();
        TranslationVisitor visitor = new TranslationVisitor();
        try {
            parsedPredicate.accept((ISimpleVisitor)visitor);
        }
        catch (Exception e) {
            this.logger.error("Creation of ast failed for expression " + this.code, (Throwable)e);
            throw new EvaluationException("Could not create AST for predicate " + parsedPredicate.toString());
        }
        return visitor.getPredicate();
    }

    @Override
    public void printProlog(IPrologTermOutput pout) {
        if (this.ast == null) {
            this.ensureParsed();
        }
        if (this.getKind().equals(EvalElementType.ASSIGNMENT.toString())) {
            throw new EvaluationException("Assignments are currently unsupported for evaluation");
        }
        assert (this.ast != null);
        ASTProlog prolog = new ASTProlog(pout, null);
        this.ast.apply((Switch)prolog);
    }

    @Override
    public String getKind() {
        if (this.kind == null) {
            this.ensureParsed();
        }
        return this.kind;
    }

    public String toString() {
        return this.getCode();
    }

    @Override
    public Node getAst() {
        if (this.ast == null) {
            this.ensureParsed();
        }
        assert (this.ast != null);
        return this.ast;
    }

    @Override
    public String serialized() {
        return "#EventB:" + this.code;
    }

    @Override
    public IFormulaUUID getFormulaId() {
        return this.uuid;
    }

    @Override
    public EvaluationCommand getCommand(State stateId) {
        return new EvaluateFormulaCommand(this, stateId.getId());
    }

    public String toUnicode() {
        return UnicodeTranslator.toUnicode((String)this.code);
    }

    public IParseResult getRodinParsedResult() {
        if (this.kind == null) {
            this.ensureParsed();
        }
        if (this.kind.equals(EvalElementType.PREDICATE.toString())) {
            return FormulaFactory.getInstance(this.types).parsePredicate(this.toUnicode(), null);
        }
        if (this.kind.equals(EvalElementType.EXPRESSION.toString())) {
            return FormulaFactory.getInstance(this.types).parseExpression(this.toUnicode(), null);
        }
        if (this.kind.equals(EvalElementType.ASSIGNMENT.toString())) {
            return FormulaFactory.getInstance(this.types).parseAssignment(this.toUnicode(), null);
        }
        return null;
    }

    @Override
    public BObject translate() {
        if (!this.getKind().equals(EvalElementType.EXPRESSION.toString())) {
            throw new IllegalArgumentException();
        }
        TranslatingVisitor v = new TranslatingVisitor();
        this.getAst().apply((Switch)v);
        return v.getResult();
    }

    public Set<IFormulaExtension> getTypes() {
        return this.types;
    }
}

