/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.LtlCheckingCommand;
import de.prob.animator.domainobjects.LTL;
import de.prob.check.CheckInterrupted;
import de.prob.check.IModelCheckListener;
import de.prob.check.IModelCheckingResult;
import de.prob.check.LTLNotYetFinished;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;
import de.prob.statespace.StateSpace;

public class LTLCheckingJob
extends AbstractCommand {
    private static final int MAX = 500;
    private final StateSpace s;
    private final LTL formula;
    private final String jobId;
    private final IModelCheckListener ui;
    private IModelCheckingResult res;
    private LtlCheckingCommand cmd;
    private long time = -1L;

    public LTLCheckingJob(StateSpace s, LTL formula, String jobId, IModelCheckListener ui) {
        this.s = s;
        this.formula = formula;
        this.jobId = jobId;
        this.ui = ui;
        this.cmd = new LtlCheckingCommand(s, formula, 500);
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        if (this.time == -1L) {
            this.time = System.currentTimeMillis();
        }
        this.cmd.writeCommand(pto);
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        this.cmd.processResult(bindings);
        this.res = this.cmd.getResult();
        if (this.ui != null) {
            this.ui.updateStats(this.jobId, System.currentTimeMillis() - this.time, this.res, null);
        }
        this.completed = !(this.res instanceof LTLNotYetFinished);
        this.cmd = new LtlCheckingCommand(this.s, this.formula, 500);
    }

    public IModelCheckingResult getResult() {
        return this.res == null && this.interrupted ? new CheckInterrupted() : this.res;
    }

    @Override
    public boolean blockAnimator() {
        return true;
    }
}

