/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import com.google.common.base.Joiner;
import de.prob.animator.command.AbstractCommand;
import de.prob.cli.CliVersionNumber;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;

public class GetVersionCommand
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "get_version";
    private String major;
    private String minor;
    private String service;
    private String qualifier;
    private String svnrevision;
    private String lastchangeddate;
    private String prologinfo;
    private static final String VAR_MAJOR = "Major";
    private static final String VAR_MINOR = "Minor";
    private static final String VAR_SERVICE = "Service";
    private static final String VAR_QUALIFIER = "Qualifier";
    private static final String VAR_REVISION = "SvnRevision";
    private static final String VAR_CHANGEDATE = "LastChangedDate";
    private static final String VAR_PROLOGVERSION = "PrologInfo";

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME).printVariable(VAR_MAJOR).printVariable(VAR_MINOR).printVariable(VAR_SERVICE).printVariable(VAR_QUALIFIER).printVariable(VAR_REVISION).printVariable(VAR_CHANGEDATE).printVariable(VAR_PROLOGVERSION).closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        this.major = ((PrologTerm)bindings.get((Object)VAR_MAJOR)).getFunctor();
        this.minor = ((PrologTerm)bindings.get((Object)VAR_MINOR)).getFunctor();
        this.service = ((PrologTerm)bindings.get((Object)VAR_SERVICE)).getFunctor();
        this.qualifier = ((PrologTerm)bindings.get((Object)VAR_QUALIFIER)).getFunctor();
        this.svnrevision = ((PrologTerm)bindings.get((Object)VAR_REVISION)).getFunctor();
        this.lastchangeddate = ((PrologTerm)bindings.get((Object)VAR_CHANGEDATE)).getFunctor();
        this.prologinfo = ((PrologTerm)bindings.get((Object)VAR_PROLOGVERSION)).getFunctor();
    }

    public String getMajor() {
        return this.major;
    }

    public String getMinor() {
        return this.minor;
    }

    public String getService() {
        return this.service;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getSvnrevision() {
        return this.svnrevision;
    }

    public String getLastchangeddate() {
        return this.lastchangeddate;
    }

    public String getProloginfo() {
        return this.prologinfo;
    }

    public CliVersionNumber getVersion() {
        return new CliVersionNumber(this.major, this.minor, this.service, this.qualifier, this.svnrevision);
    }

    public String getVersionString() {
        return Joiner.on((char)'.').join((Object)this.major, (Object)this.minor, new Object[]{this.service}) + "-" + this.qualifier + " (" + this.svnrevision + ")\nLast changed: " + this.lastchangeddate + "\nProlog: " + this.prologinfo;
    }
}

