/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.animator.domainobjects.TypeCheckResult;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import java.util.ArrayList;

public class FormulaTypecheckCommand
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "evaluate_formula_typecheck";
    private final IEvalElement formula;
    private final String TYPE = "Type";
    private final String ERRORS = "Errors";
    private TypeCheckResult result;

    public FormulaTypecheckCommand(IEvalElement formula) {
        this.formula = formula;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME);
        pto.printAtom(this.formula.getKind().toString());
        this.formula.printProlog(pto);
        pto.printVariable("_");
        pto.printVariable("Type");
        pto.printVariable("Errors");
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        String type = ((PrologTerm)bindings.get((Object)"Type")).toString();
        ListPrologTerm errs = BindingGenerator.getList((PrologTerm)((PrologTerm)bindings.get((Object)"Errors")));
        ArrayList<String> errors = new ArrayList<String>();
        for (PrologTerm pt : errs) {
            errors.add(pt.toString());
        }
        this.result = new TypeCheckResult(type, errors);
    }

    public TypeCheckResult getResult() {
        return this.result;
    }
}

