/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.IStateSpaceModifier;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.exception.ProBError;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.statespace.ITraceDescription;
import de.prob.statespace.StateSpace;
import de.prob.statespace.Trace;
import de.prob.statespace.Transition;
import java.util.ArrayList;
import java.util.List;

public class FindValidStateCommand
extends AbstractCommand
implements IStateSpaceModifier,
ITraceDescription {
    private static final String PROLOG_COMMAND_NAME = "find_state_for_predicate";
    private static final String RESULT_VARIABLE = "R";
    private final IEvalElement predicate;
    private ResultType result;
    private String stateId;
    private Transition operation;
    private final StateSpace s;

    public FindValidStateCommand(StateSpace s, IEvalElement predicate) {
        this.s = s;
        this.predicate = predicate;
    }

    public ResultType getResult() {
        return this.result;
    }

    public String getStateId() {
        return this.stateId;
    }

    public Transition getOperation() {
        return this.operation;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME);
        if (this.predicate != null) {
            this.predicate.printProlog(pto);
        }
        pto.printVariable(RESULT_VARIABLE);
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        ResultType result;
        PrologTerm resultTerm = (PrologTerm)bindings.get((Object)RESULT_VARIABLE);
        if (resultTerm.hasFunctor("no_valid_state_found", 0)) {
            result = ResultType.NO_STATE_FOUND;
        } else if (resultTerm.hasFunctor("errors", 1)) {
            result = ResultType.ERROR;
        } else if (resultTerm.hasFunctor("interrupted", 0)) {
            result = ResultType.INTERRUPTED;
        } else if (resultTerm.hasFunctor("state_found", 2)) {
            CompoundPrologTerm term = (CompoundPrologTerm)resultTerm;
            result = ResultType.STATE_FOUND;
            this.operation = Transition.createTransitionFromCompoundPrologTerm(this.s, (CompoundPrologTerm)term.getArgument(1));
            this.stateId = term.getArgument(2).toString();
        } else {
            throw new ProBError("unexpected result when trying to find a valid state: " + resultTerm);
        }
        this.result = result;
    }

    @Override
    public List<Transition> getNewTransitions() {
        ArrayList<Transition> ops = new ArrayList<Transition>();
        if (this.operation != null) {
            ops.add(this.operation);
        }
        return ops;
    }

    @Override
    public Trace getTrace(StateSpace s) {
        Trace t;
        if (this.stateId != null && this.result.equals((Object)ResultType.STATE_FOUND) && (t = s.getTrace(this.stateId)) != null) {
            return t;
        }
        throw new RuntimeException("Was not able to produce a valid trace to the state specified by predicate: " + this.predicate.getCode() + " Result type was: " + (Object)((Object)this.result));
    }

    public static enum ResultType {
        STATE_FOUND,
        NO_STATE_FOUND,
        INTERRUPTED,
        ERROR;

    }
}

