/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.domainobjects.EvalElementType;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.statespace.State;
import de.prob.statespace.Transition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FilterStatesForPredicateCommand
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "filter_states_for_predicate";
    private final Collection<State> ids;
    private final IEvalElement predicate;
    private final String FILTERED = "Filtered";
    private final List<String> filtered = new ArrayList<String>();
    private final List<String> errors = new ArrayList<String>();

    public FilterStatesForPredicateCommand(IEvalElement predicate, Collection<State> ids) {
        if (!predicate.getKind().equals(EvalElementType.PREDICATE.toString())) {
            throw new IllegalArgumentException("Formula in GetStatesFromPredicate must be a predicate");
        }
        this.predicate = predicate;
        this.ids = ids;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME);
        this.predicate.printProlog(pto);
        pto.openList();
        for (State id : this.ids) {
            pto.printAtomOrNumber(id.getId());
        }
        pto.closeList();
        pto.printVariable("Filtered");
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        PrologTerm term = (PrologTerm)bindings.get((Object)"Filtered");
        if (term.hasFunctor("errors", 1)) {
            PrologTerm errorL = BindingGenerator.getCompoundTerm((PrologTerm)term, (int)1).getArgument(1);
            ListPrologTerm errList = BindingGenerator.getList((PrologTerm)errorL);
            for (PrologTerm prologTerm : errList) {
                this.errors.add(prologTerm.getFunctor());
            }
        } else {
            ListPrologTerm list = BindingGenerator.getList((PrologTerm)term);
            for (PrologTerm prologTerm : list) {
                this.filtered.add(Transition.getIdFromPrologTerm(prologTerm));
            }
        }
    }

    public List<String> getFiltered() {
        return this.filtered;
    }

    public List<String> getErrors() {
        return this.errors;
    }
}

