/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.CheckBooleanPropertyCommand;
import de.prob.animator.command.CheckInitialisationStatusCommand;
import de.prob.animator.command.CheckInvariantStatusCommand;
import de.prob.animator.command.CheckMaxOperationReachedStatusCommand;
import de.prob.animator.command.CheckTimeoutStatusCommand;
import de.prob.animator.command.ComposedCommand;
import de.prob.animator.command.EvaluateRegisteredFormulasCommand;
import de.prob.animator.command.GetEnabledOperationsCommand;
import de.prob.animator.command.GetOperationsWithTimeout;
import de.prob.animator.command.GetStateBasedErrorsCommand;
import de.prob.animator.command.IStateSpaceModifier;
import de.prob.animator.domainobjects.AbstractEvalResult;
import de.prob.animator.domainobjects.IEvalElement;
import de.prob.animator.domainobjects.StateError;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.PrologTerm;
import de.prob.statespace.StateSpace;
import de.prob.statespace.Transition;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExploreStateCommand
extends AbstractCommand
implements IStateSpaceModifier {
    Logger logger = LoggerFactory.getLogger(ExploreStateCommand.class);
    private final String stateId;
    private final GetEnabledOperationsCommand getOpsCmd;
    private final EvaluateRegisteredFormulasCommand evalFormulasCmd;
    private final CheckBooleanPropertyCommand checkInitialisedCmd;
    private final CheckInvariantStatusCommand checkInvCmd;
    private final CheckBooleanPropertyCommand checkMaxOpCmd;
    private final CheckBooleanPropertyCommand checkTimeoutCmd;
    private final GetStateBasedErrorsCommand getStateErrCmd;
    private final ComposedCommand allCommands;
    private final GetOperationsWithTimeout checkTimeoutOpsCmd;

    public ExploreStateCommand(StateSpace s, String stateID, Collection<IEvalElement> formulas) {
        this.stateId = stateID;
        this.getOpsCmd = new GetEnabledOperationsCommand(s, this.stateId);
        this.evalFormulasCmd = new EvaluateRegisteredFormulasCommand(stateID, formulas);
        this.checkInitialisedCmd = new CheckInitialisationStatusCommand(this.stateId);
        this.checkInvCmd = new CheckInvariantStatusCommand(this.stateId);
        this.checkMaxOpCmd = new CheckMaxOperationReachedStatusCommand(this.stateId);
        this.checkTimeoutCmd = new CheckTimeoutStatusCommand(this.stateId);
        this.checkTimeoutOpsCmd = new GetOperationsWithTimeout(this.stateId);
        this.getStateErrCmd = new GetStateBasedErrorsCommand(this.stateId);
        this.allCommands = new ComposedCommand(this.getOpsCmd, this.evalFormulasCmd, this.checkInitialisedCmd, this.checkInvCmd, this.checkMaxOpCmd, this.checkTimeoutCmd, this.checkTimeoutOpsCmd, this.getStateErrCmd);
    }

    public String getStateID() {
        return this.stateId;
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        this.allCommands.processResult(bindings);
        boolean initialised = this.checkInitialisedCmd.getResult();
        boolean timeoutOccured = this.checkTimeoutCmd.getResult();
        List<Transition> enabledOperations = this.getOpsCmd.getEnabledOperations();
        if (!initialised && enabledOperations.isEmpty() && !timeoutOccured) {
            this.logger.error("ProB could not find valid constants. This might be caused by the animation settings (e.g., Integer range or deferred set size) or by an inconsistency in the axioms");
        }
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        this.allCommands.writeCommand(pto);
    }

    public boolean isInitialised() {
        return this.checkInitialisedCmd.getResult();
    }

    public boolean isInvariantOk() {
        return !this.checkInvCmd.isInvariantViolated();
    }

    public boolean isTimeoutOccured() {
        return this.checkTimeoutCmd.getResult();
    }

    public boolean isMaxOperationsReached() {
        return this.checkMaxOpCmd.getResult();
    }

    public Map<IEvalElement, AbstractEvalResult> getFormulaResults() {
        return this.evalFormulasCmd.getResults();
    }

    public Collection<StateError> getStateErrors() {
        return this.getStateErrCmd.getResult();
    }

    public Set<String> getOperationsWithTimeout() {
        return new HashSet<String>(this.checkTimeoutOpsCmd.getTimeouts());
    }

    @Override
    public List<AbstractCommand> getSubcommands() {
        List<AbstractCommand> subcommands = this.allCommands.getSubcommands();
        return subcommands;
    }

    @Override
    public List<Transition> getNewTransitions() {
        return this.getOpsCmd.getNewTransitions();
    }
}

