/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.animator.domainobjects.ExpandedFormula;
import de.prob.animator.domainobjects.FormulaId;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.statespace.State;

public class ExpandFormulaCommand
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "expand_formula";
    private final State stateId;
    private final String TREE = "TREE";
    private final FormulaId id;
    private ExpandedFormula result;

    public ExpandFormulaCommand(FormulaId id, State stateId) {
        this.id = id;
        this.stateId = stateId;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME);
        pto.printAtomOrNumber(this.id.getId());
        pto.printAtomOrNumber(this.stateId.getId());
        pto.printVariable("TREE");
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        CompoundPrologTerm cpt = BindingGenerator.getCompoundTerm((PrologTerm)((PrologTerm)bindings.get((Object)"TREE")), (int)4);
        this.result = new ExpandedFormula(cpt);
    }

    public ExpandedFormula getResult() {
        return this.result;
    }
}

