/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.prob.animator.command.AbstractCommand;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.IntegerPrologTerm;
import de.prob.prolog.term.PrologTerm;

public class EvalstoreCreateByStateCommand
extends AbstractCommand {
    private static final String PROLOG_COMMAND_NAME = "es_copy_from_statespace";
    private static final String STORE_ID_VAR = "ID";
    private final String stateId;
    private long evalstoreId;

    public EvalstoreCreateByStateCommand(String stateId) {
        this.stateId = stateId;
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME);
        pto.printAtomOrNumber(this.stateId);
        pto.printVariable(STORE_ID_VAR);
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        IntegerPrologTerm result = (IntegerPrologTerm)bindings.get((Object)STORE_ID_VAR);
        this.evalstoreId = result.getValue().longValue();
    }

    public long getEvalstoreId() {
        return this.evalstoreId;
    }
}

