/*
 * Decompiled with CFR 0.152.
 */
package de.prob.animator.command;

import de.be4.classicalb.core.parser.analysis.prolog.ASTProlog;
import de.be4.classicalb.core.parser.node.Switch;
import de.prob.animator.command.AbstractCommand;
import de.prob.animator.command.IStateSpaceModifier;
import de.prob.animator.domainobjects.ClassicalB;
import de.prob.animator.domainobjects.EvalElementType;
import de.prob.parser.BindingGenerator;
import de.prob.parser.ISimplifiedROMap;
import de.prob.prolog.output.IPrologTermOutput;
import de.prob.prolog.term.CompoundPrologTerm;
import de.prob.prolog.term.ListPrologTerm;
import de.prob.prolog.term.PrologTerm;
import de.prob.statespace.ITraceDescription;
import de.prob.statespace.State;
import de.prob.statespace.StateSpace;
import de.prob.statespace.Trace;
import de.prob.statespace.Transition;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConstructTraceCommand
extends AbstractCommand
implements IStateSpaceModifier,
ITraceDescription {
    private static final String PROLOG_COMMAND_NAME = "prob2_construct_trace";
    Logger logger = LoggerFactory.getLogger(ConstructTraceCommand.class);
    private static final String RESULT_VARIABLE = "Res";
    private static final String ERRORS = "Errors";
    private final List<ClassicalB> evalElement;
    private final State stateId;
    private final List<String> name;
    private final StateSpace stateSpace;
    private final List<Transition> resultTrace = new ArrayList<Transition>();
    private final List<String> errors = new ArrayList<String>();
    private List<Integer> executionNumber = new ArrayList<Integer>();

    public ConstructTraceCommand(StateSpace s, State stateId, List<String> name, List<ClassicalB> predicate, Integer executionNumber) {
        this.stateSpace = s;
        this.stateId = stateId;
        this.name = name;
        this.evalElement = predicate;
        if (name.size() != predicate.size()) {
            throw new IllegalArgumentException("Must provide the same number of names and predicates.");
        }
        for (ClassicalB classicalB : predicate) {
            if (classicalB.getKind().equals(EvalElementType.PREDICATE.toString())) continue;
            throw new IllegalArgumentException("Formula must be a predicate: " + predicate);
        }
        int size = this.name.size();
        for (int i = 0; i < size; ++i) {
            this.executionNumber.add(executionNumber);
        }
    }

    public ConstructTraceCommand(StateSpace s, State stateId, List<String> name, List<ClassicalB> predicate) {
        this(s, stateId, name, predicate, 1);
    }

    public ConstructTraceCommand(StateSpace s, State stateId, List<String> name, List<ClassicalB> predicate, List<Integer> executionNumber) {
        this(s, stateId, name, predicate);
        this.executionNumber = executionNumber;
        if (name.size() != executionNumber.size()) {
            throw new IllegalArgumentException("Must provide the same number of names and execution numbers.");
        }
    }

    @Override
    public void writeCommand(IPrologTermOutput pto) {
        pto.openTerm(PROLOG_COMMAND_NAME).printAtomOrNumber(this.stateId.getId());
        pto.openList();
        for (String n : this.name) {
            pto.printAtom(n);
        }
        pto.closeList();
        ASTProlog prolog = new ASTProlog(pto, null);
        pto.openList();
        for (ClassicalB cb : this.evalElement) {
            cb.getAst().apply((Switch)prolog);
        }
        pto.closeList();
        pto.openList();
        for (Integer n : this.executionNumber) {
            pto.printNumber((long)n.intValue());
        }
        pto.closeList();
        pto.printVariable(RESULT_VARIABLE);
        pto.printVariable(ERRORS);
        pto.closeTerm();
    }

    @Override
    public void processResult(ISimplifiedROMap<String, PrologTerm> bindings) {
        ListPrologTerm trace = BindingGenerator.getList((PrologTerm)((PrologTerm)bindings.get((Object)RESULT_VARIABLE)));
        for (PrologTerm term : trace) {
            CompoundPrologTerm t = BindingGenerator.getCompoundTerm((PrologTerm)term, (int)4);
            Transition operation = Transition.createTransitionFromCompoundPrologTerm(this.stateSpace, t);
            this.resultTrace.add(operation);
        }
        ListPrologTerm errors = BindingGenerator.getList((PrologTerm)((PrologTerm)bindings.get((Object)ERRORS)));
        for (PrologTerm prologTerm : errors) {
            this.errors.add(prologTerm.getFunctor());
        }
    }

    @Override
    public List<Transition> getNewTransitions() {
        return this.resultTrace;
    }

    public State getFinalState() {
        return this.resultTrace.get(this.resultTrace.size() - 1).getDestination();
    }

    @Override
    public Trace getTrace(StateSpace s) throws RuntimeException {
        Trace t = s.getTrace(this.stateId.getId());
        return t.addTransitions(this.resultTrace);
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }
}

