/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import org.spockframework.runtime.IRunListener;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.SpecInfo;

public class MasterRunListener
implements IRunListener {
    private final SpecInfo spec;

    public MasterRunListener(SpecInfo spec) {
        this.spec = spec;
    }

    public void beforeSpec(SpecInfo spec) {
        for (IRunListener listener : spec.getListeners()) {
            listener.beforeSpec(spec);
        }
    }

    public void beforeFeature(FeatureInfo feature) {
        for (IRunListener listener : this.spec.getListeners()) {
            listener.beforeFeature(feature);
        }
    }

    public void beforeIteration(IterationInfo iteration) {
        for (IRunListener listener : this.spec.getListeners()) {
            listener.beforeIteration(iteration);
        }
    }

    public void afterIteration(IterationInfo iteration) {
        for (IRunListener listener : this.spec.getListeners()) {
            listener.afterIteration(iteration);
        }
    }

    public void afterFeature(FeatureInfo feature) {
        for (IRunListener listener : this.spec.getListeners()) {
            listener.afterFeature(feature);
        }
    }

    public void afterSpec(SpecInfo spec) {
        for (IRunListener listener : spec.getListeners()) {
            listener.afterSpec(spec);
        }
    }

    public void error(ErrorInfo error) {
        for (IRunListener listener : this.spec.getListeners()) {
            listener.error(error);
        }
    }

    public void specSkipped(SpecInfo spec) {
        for (IRunListener listener : spec.getListeners()) {
            listener.specSkipped(spec);
        }
    }

    public void featureSkipped(FeatureInfo feature) {
        for (IRunListener listener : this.spec.getListeners()) {
            listener.featureSkipped(feature);
        }
    }
}

