/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.junit.runner.Description;
import org.spockframework.runtime.IRunSupervisor;
import org.spockframework.runtime.RunStatus;
import org.spockframework.runtime.SafeIterationNameProvider;
import org.spockframework.runtime.SpecificationContext;
import org.spockframework.runtime.extension.IMethodInterceptor;
import org.spockframework.runtime.extension.MethodInvocation;
import org.spockframework.runtime.model.ErrorInfo;
import org.spockframework.runtime.model.FeatureInfo;
import org.spockframework.runtime.model.IterationInfo;
import org.spockframework.runtime.model.MethodInfo;
import org.spockframework.runtime.model.MethodKind;
import org.spockframework.runtime.model.SpecInfo;
import org.spockframework.util.InternalSpockError;
import org.spockframework.util.ReflectionUtil;
import spock.lang.Specification;

public class BaseSpecRunner {
    private static final Method DO_RUN_SPEC;
    private static final Method DO_RUN_FEATURE;
    private static final Method DO_RUN_ITERATION;
    protected static final Object[] EMPTY_ARGS;
    protected final SpecInfo spec;
    protected final IRunSupervisor supervisor;
    protected FeatureInfo currentFeature;
    protected IterationInfo currentIteration;
    protected Specification sharedInstance;
    protected Specification currentInstance;
    protected int runStatus = 0;

    public BaseSpecRunner(SpecInfo spec, IRunSupervisor supervisor) {
        this.spec = spec;
        this.supervisor = supervisor;
    }

    public int run() {
        if (this.spec.isExcluded() || this.spec.isSkipped()) {
            this.supervisor.specSkipped(this.spec);
            return 0;
        }
        this.createSpecInstance(true);
        this.invokeSharedInitializer();
        this.runSpec();
        return this.resetStatus(16);
    }

    private void runSpec() {
        if (this.runStatus != 0) {
            return;
        }
        this.supervisor.beforeSpec(this.spec);
        this.invoke(this, this.createMethodInfoForDoRunSpec(), new Object[0]);
        this.supervisor.afterSpec(this.spec);
    }

    private MethodInfo createMethodInfoForDoRunSpec() {
        MethodInfo result = new MethodInfo();
        result.setParent(this.spec);
        result.setKind(MethodKind.SPEC_EXECUTION);
        result.setReflection(DO_RUN_SPEC);
        result.setDescription(this.spec.getDescription());
        for (IMethodInterceptor interceptor : this.spec.getInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    public void doRunSpec() {
        this.invokeSetupSpec();
        this.runFeatures();
        this.invokeCleanupSpec();
    }

    private void createSpecInstance(boolean shared) {
        if (this.runStatus != 0) {
            return;
        }
        try {
            if (shared) {
                this.sharedInstance = (Specification)((Class)this.spec.getReflection()).newInstance();
                this.getSpecificationContext(this.sharedInstance).setSharedInstance(this.sharedInstance);
            } else {
                this.currentInstance = (Specification)((Class)this.spec.getReflection()).newInstance();
                this.getSpecificationContext(this.currentInstance).setSharedInstance(this.sharedInstance);
            }
        }
        catch (Throwable t) {
            throw new InternalSpockError("Failed to instantiate spec '%s'", t).withArgs(this.spec.getName());
        }
    }

    private void invokeSharedInitializer() {
        for (SpecInfo curr : this.spec.getSpecsTopToBottom()) {
            if (this.runStatus != 0) {
                return;
            }
            this.invoke(this.sharedInstance, curr.getSharedInitializerMethod(), new Object[0]);
        }
    }

    private void invokeSetupSpec() {
        for (SpecInfo curr : this.spec.getSpecsTopToBottom()) {
            if (this.runStatus != 0) {
                return;
            }
            this.invoke(this.sharedInstance, curr.getSetupSpecMethod(), new Object[0]);
        }
    }

    private void runFeatures() {
        for (FeatureInfo feature : this.spec.getAllFeaturesInExecutionOrder()) {
            if (this.resetStatus(8) != 0) {
                return;
            }
            this.currentFeature = feature;
            this.runFeature();
            this.currentFeature = null;
        }
    }

    private void invokeCleanupSpec() {
        for (SpecInfo curr : this.spec.getSpecsBottomToTop()) {
            if (RunStatus.action(this.runStatus) == 2) {
                return;
            }
            this.invoke(this.sharedInstance, curr.getCleanupSpecMethod(), new Object[0]);
        }
    }

    private void runFeature() {
        if (this.runStatus != 0) {
            return;
        }
        if (this.currentFeature.isExcluded()) {
            return;
        }
        if (this.currentFeature.isSkipped()) {
            this.supervisor.featureSkipped(this.currentFeature);
            return;
        }
        this.supervisor.beforeFeature(this.currentFeature);
        this.invoke(this, this.createMethodInfoForDoRunFeature(), new Object[0]);
        this.supervisor.afterFeature(this.currentFeature);
    }

    private MethodInfo createMethodInfoForDoRunFeature() {
        MethodInfo result = new MethodInfo();
        result.setParent(this.currentFeature.getParent());
        result.setKind(MethodKind.FEATURE_EXECUTION);
        result.setReflection(DO_RUN_FEATURE);
        result.setFeature(this.currentFeature);
        result.setDescription(this.currentFeature.getDescription());
        for (IMethodInterceptor interceptor : this.currentFeature.getInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    public void doRunFeature() {
        this.currentFeature.setIterationNameProvider(new SafeIterationNameProvider(this.currentFeature.getIterationNameProvider()));
        if (this.currentFeature.isParameterized()) {
            this.runParameterizedFeature();
        } else {
            this.runSimpleFeature();
        }
    }

    private void runSimpleFeature() {
        if (this.runStatus != 0) {
            return;
        }
        this.initializeAndRunIteration(EMPTY_ARGS, 1);
        this.resetStatus(4);
    }

    protected void initializeAndRunIteration(Object[] dataValues, int estimatedNumIterations) {
        if (this.runStatus != 0) {
            return;
        }
        this.createSpecInstance(false);
        this.invokeInitializer();
        this.runIteration(dataValues, estimatedNumIterations);
    }

    private void runIteration(Object[] dataValues, int estimatedNumIterations) {
        if (this.runStatus != 0) {
            return;
        }
        this.currentIteration = this.createIterationInfo(dataValues, estimatedNumIterations);
        this.getSpecificationContext(this.currentInstance).setIterationInfo(this.currentIteration);
        this.supervisor.beforeIteration(this.currentIteration);
        this.invoke(this, this.createMethodInfoForDoRunIteration(), new Object[0]);
        this.supervisor.afterIteration(this.currentIteration);
        this.currentIteration = null;
    }

    private IterationInfo createIterationInfo(Object[] dataValues, int estimatedNumIterations) {
        this.currentIteration = new IterationInfo(this.currentFeature, dataValues, estimatedNumIterations);
        String iterationName = this.currentFeature.getIterationNameProvider().getName(this.currentIteration);
        this.currentIteration.setName(iterationName);
        Description description = Description.createTestDescription((Class)((Class)this.spec.getReflection()), (String)iterationName, (Annotation[])((Method)this.currentFeature.getFeatureMethod().getReflection()).getAnnotations());
        this.currentIteration.setDescription(description);
        return this.currentIteration;
    }

    private MethodInfo createMethodInfoForDoRunIteration() {
        MethodInfo result = new MethodInfo();
        result.setParent(this.currentFeature.getParent());
        result.setKind(MethodKind.ITERATION_EXECUTION);
        result.setReflection(DO_RUN_ITERATION);
        result.setFeature(this.currentFeature);
        result.setDescription(this.currentFeature.getDescription());
        for (IMethodInterceptor interceptor : this.currentFeature.getIterationInterceptors()) {
            result.addInterceptor(interceptor);
        }
        return result;
    }

    public void doRunIteration() {
        this.invokeSetup();
        this.invokeFeatureMethod();
        this.invokeCleanup();
    }

    protected int resetStatus(int scope) {
        if (RunStatus.scope(this.runStatus) <= scope) {
            this.runStatus = 0;
        }
        return this.runStatus;
    }

    protected void runParameterizedFeature() {
        throw new UnsupportedOperationException("This runner cannot run parameterized features");
    }

    private void invokeInitializer() {
        for (SpecInfo curr : this.spec.getSpecsTopToBottom()) {
            if (this.runStatus != 0) {
                return;
            }
            this.invoke(this.currentInstance, curr.getInitializerMethod(), new Object[0]);
        }
    }

    private void invokeSetup() {
        for (SpecInfo curr : this.spec.getSpecsTopToBottom()) {
            if (this.runStatus != 0) {
                return;
            }
            this.invoke(this.currentInstance, curr.getSetupMethod(), new Object[0]);
        }
    }

    private void invokeFeatureMethod() {
        if (this.runStatus != 0) {
            return;
        }
        this.invoke(this.currentInstance, this.currentFeature.getFeatureMethod(), this.currentIteration.getDataValues());
    }

    private void invokeCleanup() {
        this.invokeIterationCleanups();
        for (SpecInfo curr : this.spec.getSpecsBottomToTop()) {
            if (RunStatus.action(this.runStatus) == 2) {
                return;
            }
            this.invoke(this.currentInstance, curr.getCleanupMethod(), new Object[0]);
        }
    }

    private void invokeIterationCleanups() {
        for (Runnable cleanup : this.currentIteration.getCleanups()) {
            if (RunStatus.action(this.runStatus) == 2) {
                return;
            }
            try {
                cleanup.run();
            }
            catch (Throwable t) {
                ErrorInfo error = new ErrorInfo(this.spec.getCleanupMethod(), t);
                this.runStatus = this.supervisor.error(error);
            }
        }
    }

    private void invoke(Object target, MethodInfo method, Object ... arguments) {
        if (method.getInterceptors().isEmpty()) {
            this.invokeRaw(target, method, arguments);
            return;
        }
        MethodInvocation invocation = new MethodInvocation(this.currentFeature, this.currentIteration, this.sharedInstance, this.currentInstance, target, method, arguments);
        try {
            invocation.proceed();
        }
        catch (Throwable t) {
            ErrorInfo error = new ErrorInfo(method, t);
            this.runStatus = this.supervisor.error(error);
        }
    }

    protected Object invokeRaw(Object target, MethodInfo method, Object ... arguments) {
        if (method.isStub()) {
            return null;
        }
        try {
            return ReflectionUtil.invokeMethod(target, (Method)method.getReflection(), arguments);
        }
        catch (Throwable t) {
            this.runStatus = this.supervisor.error(new ErrorInfo(method, t));
            return null;
        }
    }

    protected SpecificationContext getSpecificationContext(Specification instance) {
        return (SpecificationContext)instance.getSpecificationContext();
    }

    static {
        EMPTY_ARGS = new Object[0];
        try {
            DO_RUN_SPEC = BaseSpecRunner.class.getMethod("doRunSpec", new Class[0]);
            DO_RUN_FEATURE = BaseSpecRunner.class.getMethod("doRunFeature", new Class[0]);
            DO_RUN_ITERATION = BaseSpecRunner.class.getMethod("doRunIteration", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new InternalSpockError(e);
        }
    }
}

