/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.mock.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.NoOp;
import org.spockframework.mock.CannotCreateMockException;
import org.spockframework.mock.ISpockMockObject;
import org.spockframework.mock.runtime.CglibMockInterceptorAdapter;
import org.spockframework.mock.runtime.DynamicProxyMockInterceptorAdapter;
import org.spockframework.mock.runtime.IProxyBasedMockInterceptor;
import org.spockframework.mock.runtime.MockInstantiator;
import org.spockframework.runtime.InvalidSpecException;
import org.spockframework.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyBasedMockFactory {
    private static final boolean cglibAvailable = ReflectionUtil.isClassAvailable("net.sf.cglib.proxy.Enhancer");
    public static ProxyBasedMockFactory INSTANCE = new ProxyBasedMockFactory();

    public Object create(Class<?> mockType, List<Class<?>> additionalInterfaces, List<Object> constructorArgs, IProxyBasedMockInterceptor mockInterceptor, ClassLoader classLoader, boolean useObjenesis) throws CannotCreateMockException {
        Object proxy;
        if (mockType.isInterface()) {
            proxy = this.createDynamicProxyMock(mockType, additionalInterfaces, constructorArgs, mockInterceptor, classLoader);
        } else if (cglibAvailable) {
            proxy = CglibMockFactory.createMock(mockType, additionalInterfaces, constructorArgs, mockInterceptor, classLoader, useObjenesis);
        } else {
            throw new CannotCreateMockException(mockType, ". Mocking of non-interface types requires the CGLIB library. Please put cglib-nodep-2.2 or higher on the class path.");
        }
        return proxy;
    }

    private Object createDynamicProxyMock(Class<?> mockType, List<Class<?>> additionalInterfaces, List<Object> constructorArgs, IProxyBasedMockInterceptor mockInterceptor, ClassLoader classLoader) {
        if (constructorArgs != null) {
            throw new InvalidSpecException("Interface based mocks may not have constructor arguments");
        }
        ArrayList interfaces = new ArrayList();
        interfaces.add(mockType);
        interfaces.addAll(additionalInterfaces);
        interfaces.add(ISpockMockObject.class);
        return Proxy.newProxyInstance(classLoader, interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)new DynamicProxyMockInterceptorAdapter(mockInterceptor));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CglibMockFactory {
        private CglibMockFactory() {
        }

        static Object createMock(Class<?> type, List<Class<?>> additionalInterfaces, List<Object> constructorArgs, IProxyBasedMockInterceptor interceptor, ClassLoader classLoader, boolean useObjenesis) {
            ConstructorFriendlyEnhancer enhancer = new ConstructorFriendlyEnhancer();
            enhancer.setClassLoader(classLoader);
            enhancer.setSuperclass(type);
            ArrayList interfaces = new ArrayList();
            interfaces.addAll(additionalInterfaces);
            interfaces.add(ISpockMockObject.class);
            enhancer.setInterfaces(interfaces.toArray(new Class[interfaces.size()]));
            enhancer.setCallbackFilter(BridgeMethodAwareCallbackFilter.INSTANCE);
            CglibMockInterceptorAdapter cglibInterceptor = new CglibMockInterceptorAdapter(interceptor);
            enhancer.setCallbackTypes(new Class[]{cglibInterceptor.getClass(), NoOp.class});
            Class enhancedType = enhancer.createClass();
            Object proxy = MockInstantiator.instantiate(type, enhancedType, constructorArgs, useObjenesis);
            ((Factory)proxy).setCallbacks(new Callback[]{cglibInterceptor, NoOp.INSTANCE});
            return proxy;
        }

        static class BridgeMethodAwareCallbackFilter
        implements CallbackFilter {
            static BridgeMethodAwareCallbackFilter INSTANCE = new BridgeMethodAwareCallbackFilter();

            BridgeMethodAwareCallbackFilter() {
            }

            public int accept(Method method) {
                return method.isBridge() ? 1 : 0;
            }
        }

        static class ConstructorFriendlyEnhancer
        extends Enhancer {
            ConstructorFriendlyEnhancer() {
            }

            protected void filterConstructors(Class clazz, List constructors) {
            }
        }
    }
}

