/*
 * Decompiled with CFR 0.152.
 */
package org.spockframework.compiler;

import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.syntax.Types;
import org.spockframework.compiler.AbstractDeepBlockRewriter;
import org.spockframework.compiler.AstUtil;
import org.spockframework.compiler.ConditionRewriter;
import org.spockframework.compiler.IRewriteResources;
import org.spockframework.compiler.InteractionRewriter;
import org.spockframework.compiler.model.Block;
import org.spockframework.compiler.model.ExpectBlock;
import org.spockframework.compiler.model.FeatureMethod;
import org.spockframework.compiler.model.FixtureMethod;
import org.spockframework.compiler.model.Method;
import org.spockframework.compiler.model.ThenBlock;

public class DeepBlockRewriter
extends AbstractDeepBlockRewriter {
    private final IRewriteResources resources;

    public DeepBlockRewriter(IRewriteResources resources) {
        super(resources.getCurrentBlock());
        this.resources = resources;
    }

    public void visit(Block block) {
        super.visit(block);
    }

    public void visitAssertStatement(AssertStatement stat) {
        super.visitAssertStatement(stat);
        this.conditionFound = true;
        this.replaceVisitedStatementWith(ConditionRewriter.rewriteExplicitCondition(stat, this.resources));
    }

    protected void doVisitExpressionStatement(ExpressionStatement stat) {
        super.doVisitExpressionStatement(stat);
        boolean handled = stat == this.lastSpecialMethodCallStat || this.handleInteraction(stat) || this.handleImplicitCondition(stat);
    }

    protected void doVisitClosureExpression(ClosureExpression expr) {
        this.fixUpParameters(expr.getVariableScope(), true);
        super.doVisitClosureExpression(expr);
        if (this.conditionFound) {
            this.defineValueRecorder(expr);
        }
    }

    public void visitBlockStatement(BlockStatement stat) {
        super.visitBlockStatement(stat);
        this.fixUpParameters(stat.getVariableScope(), false);
    }

    public void visitDeclarationExpression(DeclarationExpression expr) {
        this.visitBinaryExpression((BinaryExpression)expr);
    }

    protected void doVisitMethodCallExpression(MethodCallExpression expr) {
        super.doVisitMethodCallExpression(expr);
        boolean handled = this.handleMockCall(expr) || this.handleThrownCall(expr) || this.handleOldCall(expr) || this.handleInteractionBlockCall(expr) || this.forbidUseOfSuperInFixtureMethod(expr);
    }

    private boolean handleInteraction(ExpressionStatement stat) {
        InteractionRewriter rewriter = new InteractionRewriter(this.resources, this.getCurrentWithOrMockClosure());
        ExpressionStatement interaction = rewriter.rewrite(stat);
        if (interaction == null) {
            return false;
        }
        if (this.block instanceof ExpectBlock) {
            this.resources.getErrorReporter().error((ASTNode)stat, "Interactions are not allowed in '%s' blocks. Put them before the '%s' block or into a 'then' block.", this.block.getName(), this.block.getName());
            return true;
        }
        this.replaceVisitedStatementWith((Statement)interaction);
        this.interactionFound = true;
        return true;
    }

    private boolean handleImplicitCondition(ExpressionStatement stat) {
        if (!(stat == this.currTopLevelStat && this.isThenOrExpectBlock() || this.currSpecialMethodCall.isWithCall() || this.currSpecialMethodCall.isConditionBlock())) {
            return false;
        }
        if (!DeepBlockRewriter.isImplicitCondition((Statement)stat)) {
            return false;
        }
        this.checkIsValidImplicitCondition((Statement)stat);
        this.conditionFound = true;
        Statement condition = ConditionRewriter.rewriteImplicitCondition(stat, this.resources);
        this.replaceVisitedStatementWith(condition);
        return true;
    }

    private boolean handleMockCall(MethodCallExpression expr) {
        if (!this.currSpecialMethodCall.isTestDouble(expr)) {
            return false;
        }
        if (((MethodNode)this.resources.getCurrentMethod().getAst()).isStatic()) {
            this.resources.getErrorReporter().error((ASTNode)expr, "Mocks cannot be created in static scope", new Object[0]);
        }
        this.currSpecialMethodCall.expand();
        return true;
    }

    private boolean handleThrownCall(MethodCallExpression expr) {
        if (!this.currSpecialMethodCall.isExceptionCondition(expr)) {
            return false;
        }
        if (!(this.block instanceof ThenBlock)) {
            this.resources.getErrorReporter().error((ASTNode)expr, "Exception conditions are only allowed in 'then' blocks", new Object[0]);
            return true;
        }
        if (this.isExceptionConditionFound()) {
            this.resources.getErrorReporter().error((ASTNode)expr, "Only one exception condition is allowed per 'then' block", new Object[0]);
            return true;
        }
        if (!this.currSpecialMethodCall.isMatch(this.currTopLevelStat)) {
            this.resources.getErrorReporter().error((ASTNode)expr, "Exception conditions are only allowed as top-level statements", new Object[0]);
            return true;
        }
        this.foundExceptionCondition = expr;
        if (this.currSpecialMethodCall.isThrownCall()) {
            this.currSpecialMethodCall.expand();
        }
        return true;
    }

    private boolean handleOldCall(MethodCallExpression expr) {
        if (!this.currSpecialMethodCall.isOldCall(expr)) {
            return false;
        }
        if (!(this.block instanceof ThenBlock)) {
            this.resources.getErrorReporter().error((ASTNode)expr, "old() is only allowed in 'then' blocks", new Object[0]);
            return true;
        }
        expr.setMethod((Expression)new ConstantExpression((Object)(expr.getMethodAsString() + "Impl")));
        List<Expression> args = AstUtil.getArgumentList((Expression)expr);
        VariableExpression oldValue = this.resources.captureOldValue(args.get(0));
        args.set(0, (Expression)oldValue);
        if (this.currClosure != null) {
            oldValue.setClosureSharedVariable(true);
            this.currClosure.getVariableScope().putReferencedLocalVariable((Variable)oldValue);
        }
        return true;
    }

    private boolean handleInteractionBlockCall(MethodCallExpression expr) {
        if (!this.currSpecialMethodCall.isInteractionCall(expr)) {
            return false;
        }
        this.interactionFound = true;
        return true;
    }

    private void defineValueRecorder(ClosureExpression expr) {
        this.resources.defineValueRecorder(AstUtil.getStatements(expr));
    }

    private void fixUpParameters(VariableScope scope, boolean isClosureScope) {
        Method method = this.resources.getCurrentMethod();
        if (!(method instanceof FeatureMethod)) {
            return;
        }
        for (Parameter param : ((MethodNode)method.getAst()).getParameters()) {
            Variable var = scope.getReferencedClassVariable(param.getName());
            if (!(var instanceof DynamicVariable)) continue;
            scope.removeReferencedClassVariable(param.getName());
            scope.putReferencedLocalVariable((Variable)param);
            if (!isClosureScope) continue;
            param.setClosureSharedVariable(true);
        }
    }

    private boolean forbidUseOfSuperInFixtureMethod(MethodCallExpression expr) {
        Method currMethod = this.resources.getCurrentMethod();
        Expression target = expr.getObjectExpression();
        if (currMethod instanceof FixtureMethod && target instanceof VariableExpression && ((VariableExpression)target).isSuperExpression() && currMethod.getName().equals(expr.getMethodAsString())) {
            this.resources.getErrorReporter().error((ASTNode)expr, "A base class fixture method should not be called explicitly because it is always invoked automatically by the framework", new Object[0]);
            return true;
        }
        return false;
    }

    private ClosureExpression getCurrentWithOrMockClosure() {
        if (this.currSpecialMethodCall.isWithCall() || this.currSpecialMethodCall.isTestDouble()) {
            return this.currSpecialMethodCall.getClosureExpr();
        }
        return null;
    }

    private boolean isThenOrExpectBlock() {
        return this.block instanceof ThenBlock || this.block instanceof ExpectBlock;
    }

    public static boolean isImplicitCondition(Statement stat) {
        return stat instanceof ExpressionStatement && !(((ExpressionStatement)stat).getExpression() instanceof DeclarationExpression);
    }

    private void checkIsValidImplicitCondition(Statement stat) {
        BinaryExpression binExpr = AstUtil.getExpression(stat, BinaryExpression.class);
        if (binExpr == null) {
            return;
        }
        if (Types.ofType((int)binExpr.getOperation().getType(), (int)1100)) {
            this.resources.getErrorReporter().error((ASTNode)stat, "Expected a condition, but found an assignment. Did you intend to write '==' ?", new Object[0]);
        }
    }
}

